% Sample trajectory data
trajectory1 = data1;
trajectory2 = data2;

% Define the diameter of the petri dish and grid size
dish_diameter = 90;
grid_size = 1; % mm
dish_radius = dish_diameter / 2;

% Calculate the number of grids
num_grids = ceil(dish_diameter / grid_size);

% Initialize the coverage grid matrices
coverage1 = zeros(num_grids);
coverage2 = zeros(num_grids);

% Define a function to map coordinates to grid indices
map_to_grid = @(x, y, grid_size, dish_radius) ...
    (floor([(x + dish_radius) / grid_size, (y + dish_radius) / grid_size]) + 1);

% Normalize trajectory data to the range of the petri dish
normalize_trajectory = @(trajectory, dish_radius) ...
    max(min(trajectory + dish_radius, dish_diameter), 0) - dish_radius;

trajectory1 = normalize_trajectory(trajectory1, dish_radius);
trajectory2 = normalize_trajectory(trajectory2, dish_radius);

% Calculate the coverage grid for the queen individual
for i = 1:size(trajectory1, 1)
    grid_idx = map_to_grid(trajectory1(i, 1), trajectory1(i, 2), grid_size, dish_radius);
    if all(grid_idx > 0) && all(grid_idx <= num_grids)
        coverage1(grid_idx(1), grid_idx(2)) = 1;
    end
end

% Calculate the coverage grid for the worker individual
for i = 1:size(trajectory2, 1)
    grid_idx = map_to_grid(trajectory2(i, 1), trajectory2(i, 2), grid_size, dish_radius);
    if all(grid_idx > 0) && all(grid_idx <= num_grids)
        coverage2(grid_idx(1), grid_idx(2)) = 1;
    end
end

% Calculate the number of covered grids and coverage rate
num_covered_grids1 = sum(coverage1(:));
num_covered_grids2 = sum(coverage2(:));
total_grids = num_grids^2;

coverage_rate1 = num_covered_grids1 / total_grids;
coverage_rate2 = num_covered_grids2 / total_grids;

% Output coverage rates
fprintf('Queen coverage rate: %.2f%%\n', coverage_rate1 * 100);
fprintf('Worker coverage rate: %.2f%%\n', coverage_rate2 * 100);

% Create petri dish plot
figure;
theta = linspace(0, 2*pi, 100);
x = dish_radius * cos(theta);
y = dish_radius * sin(theta);
plot(x, y, 'k-', 'LineWidth', 2);
hold on;
axis equal;
xlim([-dish_radius, dish_radius]);
ylim([-dish_radius, dish_radius]);
xlabel('X (mm)');
ylabel('Y (mm)');
title('Coverage in the Petri Dish');

% Display the coverage in the petri dish
for i = 1:num_grids
    for j = 1:num_grids
        x_rect = [((i-1)*grid_size - dish_radius), (i*grid_size - dish_radius), ...
                  (i*grid_size - dish_radius), ((i-1)*grid_size - dish_radius)];
        y_rect = [((j-1)*grid_size - dish_radius), ((j-1)*grid_size - dish_radius), ...
                  (j*grid_size - dish_radius), (j*grid_size - dish_radius)];
        
        if coverage1(i, j) == 1
            patch(x_rect, y_rect, 'g', 'FaceAlpha', 0.5, 'EdgeColor', 'none');
        elseif coverage2(i, j) == 1
            patch(x_rect, y_rect, 'b', 'FaceAlpha', 0.5, 'EdgeColor', 'none');
        end
    end
end

legend('Petri Dish Boundary',  'Queen Coverage Area', 'Worker Coverage Area');
hold off;
